#ifndef __OBJ3D_H__
#define __OBJ3D_H__
// File: Obj3d.h

#include <afx.h>
#include <stdio.h>

typedef struct _FACE_
{
	//DWORD A,B,C;
	WORD A,B,C;
}FACE;

typedef struct _VERTEX_
{
	float x,y,z,sow,tow;
}VERTEX;

typedef struct _VERTEXLIGHT_
{
	float x,y,z;
}VERTEXLIGHT;

typedef struct _VECTORLIGHT_
{
	float x,y,z;
}VECTOR;

class CObj3d:public CObject{
private:
	DWORD m_NbVertices;
	VERTEX *m_pVertices;
	DWORD m_NbFaces;
	FACE *m_pFaces;
	bool m_bMapping;
public:
	bool Export(char *szFileName);
	void Translate(VECTOR*);
	bool GetMinMax(VECTOR*, VECTOR*);
	DWORD GetNbFaces();
	DWORD GetNbVertices();
	FACE* GetFaces();
	VERTEX* GetVertices();
	CObj3d();
	~CObj3d();
	VERTEX* AllocVertices(DWORD);
	FACE* AllocFaces(DWORD);
	void SetMapping();
	void fprint(FILE*);
};

#endif